<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Locality;
use Illuminate\Http\Request;

class LocalityController extends Controller
{
    
    
    public function getAllLocalities(Request $request)
    {
    $localities = Locality::with('country')
        ->orderBy('name', 'asc')
        ->get();
        return response()->json([
            'status' => 'success',
            'localities' => $localities
        ]);
    }

    public function getLocalitiesByCountry($country_id)
    {
        $localities = Locality::where('country_id', $country_id)
            ->where('active', 1)
            ->orderBy('name', 'asc')
            ->get();

        return response()->json([
            'status' => 'success',
            'localities' => $localities
        ]);
    }

    public function createLocality(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'country_id' => 'required|exists:countries,id',
        ]);

        $name = $request->input('name');
        $existingLocality = Locality::where('name', $name)->first();
        if ($existingLocality) {
            return response()->json([
                'status' => 'error',
                'message' => 'Ya existe una localidad con este Nombre.'
            ], 200);
        }

        $locality = Locality::create($request->only(['name', 'address', 'country_id', 'active']));
        return response()->json([
            'status' => 'success',
            'locality' => $locality,
            'message' => 'Sede creada exitosamente.'
        ], 200);
    }


    public function updateLocality(Request $request, $id)
    {
        $locality = Locality::find($id);
        if (!$locality) {
            return response()->json([
                'status' => 'error',
                'message' => 'Sede no encontrada.'
            ], 200);
        }

        $request->validate([
            'name' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'country_id' => 'required|exists:countries,id',
        ]);

        $name = $request->input('name');
        $existingLocality = Locality::where('name', $name)->where('id', '!=', $id)->first();
        if ($existingLocality) {
            return response()->json([
                'status' => 'error',
                'message' => 'Ya existe una localidad con este Nombre.'
            ], 200);
        }

        $locality->update($request->only(['name', 'address', 'country_id', 'active']));
        return response()->json([
            'status' => 'success',
            'locality' => $locality,
            'message' => 'Sede actualizada exitosamente.'
        ], 200);
    }
}
