<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Expense_category extends Model
{
    protected $table = 'expense_category';

    protected $fillable = [
        'name',
        'parent_id',
        'type'
    ];

    public function parent()
    {
        return $this->belongsTo(Expense_category::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(Expense_category::class, 'parent_id')->with('children');
    }
}
