<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Locality extends Model
{
    protected $fillable = [
        'name',
        'address',
        'country_id',
        'active',
    ];

    public function country() {
        return $this->belongsTo(Country::class);
    }
    
    public function users()
    {
        return $this->hasMany(User::class);
    }

}
