<?php

use App\Http\Controllers\API\ExpenseCategoryController;
use App\Http\Controllers\API\LocalityController;
use App\Http\Controllers\API\CountryController;
use App\Http\Controllers\API\UserController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => 'auth:api'], function(){
    Route::get('allcountries', [CountryController::class, 'getAllCountries']);
    Route::get('countries', [CountryController::class, 'getCountries']);
    Route::post('country', [CountryController::class, 'createCountry']);
    Route::put('country/{id}', [CountryController::class, 'updateCountry']);
    Route::get('localities', [LocalityController::class, 'getAllLocalities']);
    Route::post('localities', [LocalityController::class, 'createLocality']);
    Route::get('localities/{id}', [LocalityController::class, 'getLocalityById']);
    Route::get('localities/country/{country_id}', [LocalityController::class, 'getLocalitiesByCountry']);
    Route::put('localities/{id}', [LocalityController::class, 'updateLocality']);
    Route::get('expenses/tree', [ExpenseCategoryController::class, 'getTree']);
    Route::post('expenses/addChild', [ExpenseCategoryController::class, 'addChild']);

    Route::get('getalladminuserscountry', [UserController::class, 'getAllAdminUsersCountry']);
    Route::get('getalladminuserslocality/{country_id}', [UserController::class, 'getAllAdminUsersLocality']);
    Route::post('adminusercountry', [UserController::class, 'createAdminUserCountry']);
    Route::post('adminuserlocality', [UserController::class, 'createAdminUserLocality']);
    Route::put('adminusercountry/{id}', [UserController::class, 'updateAdminUserCountry']);
    Route::put('adminuserlocality/{id}', [UserController::class, 'updateAdminUserLocality']);
    Route::get('getallusersbylocality/{id}', [UserController::class, 'getAllUsersByLocality']);
    Route::post('user', [UserController::class, 'createUser']);
    Route::put('user/{id}', [UserController::class, 'updateUser']);
});

 Route::group(['prefix' => 'auth'], function(){ 
    Route::post('signup', [UserController::class, 'signup']);
    Route::post('login', [UserController::class, 'login']);
});